<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class ColonnaInEvidenza {
        private $db;
        private $id;
        private $nome;
        private $spazioOccupato;
        private $classeColonne;
        private $contenutoPrimaColonna;
        private $testoPrimaColonna;
        private $contenutoSecondaColonna;
        private $testoSecondaColonna;
        private $contenutoTerzaColonna;
        private $testoTerzaColonna;
        private $contenutoQuartaColonna;
        private $testoQuartaColonna;
        
        public function __construct($db, $id, $nome="", $spazioOccupato="", $classeColonne="", $contenutoPrimaColonna=0, $testoPrimaColonna="", $contenutoSecondaColonna=0, $testoSecondaColonna="", $contenutoTerzaColonna=0, $testoTerzaColonna="", $contenutoQuartaColonna=0, $testoQuartaColonna="") {
            $this->db = $db;
            $this->id = $id;
            $this->nome = $nome;
            $this->spazioOccupato = $spazioOccupato;
            $this->classeColonne = $classeColonne;
            $this->contenutoPrimaColonna = $contenutoPrimaColonna;
            $this->testoPrimaColonna = $testoPrimaColonna;
            $this->contenutoSecondaColonna = $contenutoSecondaColonna;
            $this->testoSecondaColonna = $testoSecondaColonna;
            $this->contenutoTerzaColonna = $contenutoTerzaColonna;
            $this->testoTerzaColonna = $testoTerzaColonna;
            $this->contenutoQuartaColonna = $contenutoQuartaColonna;
            $this->testoQuartaColonna = $testoQuartaColonna;
        }

        function crea() {
            $query ="INSERT INTO geec_colonneInEvidenza VALUES(NULL,'$this->nome','$this->spazioOccupato','$this->classeColonne', '$this->contenutoPrimaColonna','$this->contenutoSecondaColonna', '$this->contenutoTerzaColonna', '$this->contenutoQuartaColonna','$this->testoPrimaColonna','$this->testoSecondaColonna','$this->testoTerzaColonna','$this->testoQuartaColonna')";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        function modifica() {
            $query ="UPDATE geec_colonneInEvidenza SET nome='$this->nome', spazioOccupato = '$this->spazioOccupato', classeColonne='$this->classeColonne', primaColonna='$this->contenutoPrimaColonna', secondaColonna='$this->contenutoSecondaColonna', terzaColonna='$this->contenutoTerzaColonna', quartaColonna='$this->contenutoQuartaColonna', testoPrimaColonna='$this->testoPrimaColonna', testoSecondaColonna='$this->testoSecondaColonna', testoTerzaColonna='$this->testoTerzaColonna', testoQuartaColonna='$this->testoQuartaColonna' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geec_colonneInEvidenza",$this->id);
            
            // elimina le occorrenze in cui la form è presente, l'id di questo componente è 21
            eliminaOccorrenzeComponente($this->db,$this->id,21);
        }
        
        function duplica() {
            $query    = "INSERT INTO geec_colonneInEvidenza VALUES(NULL,'Copia di $this->nome')";
            $idNuovaForm = $this->db->eseguiQueryCreazione($query);
            
            $query       = "SELECT * FROM geec_elementiComponente WHERE idOccorenza='$this->id'";
            $risElementi = $this->db->eseguiQueryLettura($query);
            return $idNuovaForm;
        }
        
        function caricaDatiDalDatabase() {
            $datiColonneInEvidenza   = $this->db->leggiSingolaRiga("geec_colonneInEvidenza",$this->id);
            $this->nome                    = $datiColonneInEvidenza["nome"];
            $this->spazioOccupato          = $datiColonneInEvidenza["spazioOccupato"];
            $this->classeColonne           = $datiColonneInEvidenza["classeColonne"];
            $this->contenutoPrimaColonna   = $datiColonneInEvidenza["primaColonna"];
            $this->testoPrimaColonna       = $datiColonneInEvidenza["testoPrimaColonna"];
            $this->contenutoSecondaColonna = $datiColonneInEvidenza["secondaColonna"];
            $this->testoSecondaColonna     = $datiColonneInEvidenza["testoSecondaColonna"];
            $this->contenutoTerzaColonna   = $datiColonneInEvidenza["terzaColonna"];
            $this->testoTerzaColonna       = $datiColonneInEvidenza["testoTerzaColonna"];
            $this->contenutoQuartaColonna  = $datiColonneInEvidenza["quartaColonna"];
            $this->testoQuartaColonna      = $datiColonneInEvidenza["testoQuartaColonna"];
        }
        
        // getter & setter
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getNome() {
            return $this->nome;
        }

        public function getSpazioOccupato() {
            return $this->spazioOccupato;
        }

        public function getClasseColonne() {
            return $this->classeColonne;
        }

        public function getContenutoPrimaColonna() {
            return $this->contenutoPrimaColonna;
        }

        public function getTestoPrimaColonna() {
            return $this->testoPrimaColonna;
        }

        public function getContenutoSecondaColonna() {
            return $this->contenutoSecondaColonna;
        }

        public function getTestoSecondaColonna() {
            return $this->testoSecondaColonna;
        }

        public function getContenutoTerzaColonna() {
            return $this->contenutoTerzaColonna;
        }

        public function getTestoTerzaColonna() {
            return $this->testoTerzaColonna;
        }

        public function getContenutoQuartaColonna() {
            return $this->contenutoQuartaColonna;
        }

        public function getTestoQuartaColonna() {
            return $this->testoQuartaColonna;
        }

        public function setDb($db) {
            $this->db = $db;
        }

        public function setId($id) {
            $this->id = $id;
        }

        public function setNome($nome) {
            $this->nome = $nome;
        }

        public function setSpazioOccupato($spazioOccupato) {
            $this->spazioOccupato = $spazioOccupato;
        }

        public function setClasseColonne($classeColonne) {
            $this->classeColonne = $classeColonne;
        }

        public function setContenutoPrimaColonna($contenutoPrimaColonna) {
            $this->contenutoPrimaColonna = $contenutoPrimaColonna;
        }

        public function setTestoPrimaColonna($testoPrimaColonna) {
            $this->testoPrimaColonna = $testoPrimaColonna;
        }

        public function setContenutoSecondaColonna($contenutoSecondaColonna) {
            $this->contenutoSecondaColonna = $contenutoSecondaColonna;
        }

        public function setTestoSecondaColonna($testoSecondaColonna) {
            $this->testoSecondaColonna = $testoSecondaColonna;
        }

        public function setContenutoTerzaColonna($contenutoTerzaColonna) {
            $this->contenutoTerzaColonna = $contenutoTerzaColonna;
        }

        public function setTestoTerzaColonna($testoTerzaColonna) {
            $this->testoTerzaColonna = $testoTerzaColonna;
        }

        public function setContenutoQuartaColonna($contenutoQuartaColonna) {
            $this->contenutoQuartaColonna = $contenutoQuartaColonna;
        }

        public function setTestoQuartaColonna($testoQuartaColonna) {
            $this->testoQuartaColonna = $testoQuartaColonna;
        }
        
    }